/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.AbstractArrowPickupFix;
import net.minecraft.util.datafix.fixes.AddFlagIfNotPresentFix;
import net.minecraft.util.datafix.fixes.AddNewChoices;
import net.minecraft.util.datafix.fixes.AdvancementsFix;
import net.minecraft.util.datafix.fixes.AdvancementsRenameFix;
import net.minecraft.util.datafix.fixes.AttributesRename;
import net.minecraft.util.datafix.fixes.BedItemColorFix;
import net.minecraft.util.datafix.fixes.BeehivePoiRenameFix;
import net.minecraft.util.datafix.fixes.BiomeFix;
import net.minecraft.util.datafix.fixes.BitStorageAlignFix;
import net.minecraft.util.datafix.fixes.BlockEntityBannerColorFix;
import net.minecraft.util.datafix.fixes.BlockEntityBlockStateFix;
import net.minecraft.util.datafix.fixes.BlockEntityCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.BlockEntityIdFix;
import net.minecraft.util.datafix.fixes.BlockEntityJukeboxFix;
import net.minecraft.util.datafix.fixes.BlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.BlockEntityShulkerBoxColorFix;
import net.minecraft.util.datafix.fixes.BlockEntitySignTextStrictJsonFix;
import net.minecraft.util.datafix.fixes.BlockEntityUUIDFix;
import net.minecraft.util.datafix.fixes.BlockNameFlatteningFix;
import net.minecraft.util.datafix.fixes.BlockRenameFix;
import net.minecraft.util.datafix.fixes.BlockRenameFixWithJigsaw;
import net.minecraft.util.datafix.fixes.BlockStateStructureTemplateFix;
import net.minecraft.util.datafix.fixes.CatTypeFix;
import net.minecraft.util.datafix.fixes.CauldronRenameFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.util.datafix.fixes.ChunkBedBlockEntityInjecterFix;
import net.minecraft.util.datafix.fixes.ChunkBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkLightRemoveFix;
import net.minecraft.util.datafix.fixes.ChunkPalettedStorageFix;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.ChunkRenamesFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix2;
import net.minecraft.util.datafix.fixes.ChunkStructuresTemplateRenameFix;
import net.minecraft.util.datafix.fixes.ChunkToProtochunkFix;
import net.minecraft.util.datafix.fixes.ColorlessShulkerEntityFix;
import net.minecraft.util.datafix.fixes.DyeItemRenameFix;
import net.minecraft.util.datafix.fixes.EntityArmorStandSilentFix;
import net.minecraft.util.datafix.fixes.EntityBlockStateFix;
import net.minecraft.util.datafix.fixes.EntityCatSplitFix;
import net.minecraft.util.datafix.fixes.EntityCodSalmonFix;
import net.minecraft.util.datafix.fixes.EntityCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.EntityElderGuardianSplitFix;
import net.minecraft.util.datafix.fixes.EntityEquipmentToArmorAndHandFix;
import net.minecraft.util.datafix.fixes.EntityHealthFix;
import net.minecraft.util.datafix.fixes.EntityHorseSaddleFix;
import net.minecraft.util.datafix.fixes.EntityHorseSplitFix;
import net.minecraft.util.datafix.fixes.EntityIdFix;
import net.minecraft.util.datafix.fixes.EntityItemFrameDirectionFix;
import net.minecraft.util.datafix.fixes.EntityMinecartIdentifiersFix;
import net.minecraft.util.datafix.fixes.EntityPaintingItemFrameDirectionFix;
import net.minecraft.util.datafix.fixes.EntityPaintingMotiveFix;
import net.minecraft.util.datafix.fixes.EntityProjectileOwnerFix;
import net.minecraft.util.datafix.fixes.EntityPufferfishRenameFix;
import net.minecraft.util.datafix.fixes.EntityRavagerRenameFix;
import net.minecraft.util.datafix.fixes.EntityRedundantChanceTagsFix;
import net.minecraft.util.datafix.fixes.EntityRidingToPassengersFix;
import net.minecraft.util.datafix.fixes.EntityShulkerColorFix;
import net.minecraft.util.datafix.fixes.EntityShulkerRotationFix;
import net.minecraft.util.datafix.fixes.EntitySkeletonSplitFix;
import net.minecraft.util.datafix.fixes.EntityStringUuidFix;
import net.minecraft.util.datafix.fixes.EntityTheRenameningFix;
import net.minecraft.util.datafix.fixes.EntityTippedArrowFix;
import net.minecraft.util.datafix.fixes.EntityUUIDFix;
import net.minecraft.util.datafix.fixes.EntityWolfColorFix;
import net.minecraft.util.datafix.fixes.EntityZombieSplitFix;
import net.minecraft.util.datafix.fixes.EntityZombieVillagerTypeFix;
import net.minecraft.util.datafix.fixes.EntityZombifiedPiglinRenameFix;
import net.minecraft.util.datafix.fixes.ForcePoiRebuild;
import net.minecraft.util.datafix.fixes.FurnaceRecipeFix;
import net.minecraft.util.datafix.fixes.GossipUUIDFix;
import net.minecraft.util.datafix.fixes.HeightmapRenamingFix;
import net.minecraft.util.datafix.fixes.IglooMetadataRemovalFix;
import net.minecraft.util.datafix.fixes.ItemBannerColorFix;
import net.minecraft.util.datafix.fixes.ItemCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.ItemIdFix;
import net.minecraft.util.datafix.fixes.ItemLoreFix;
import net.minecraft.util.datafix.fixes.ItemPotionFix;
import net.minecraft.util.datafix.fixes.ItemRenameFix;
import net.minecraft.util.datafix.fixes.ItemShulkerBoxColorFix;
import net.minecraft.util.datafix.fixes.ItemSpawnEggFix;
import net.minecraft.util.datafix.fixes.ItemStackEnchantmentNamesFix;
import net.minecraft.util.datafix.fixes.ItemStackMapIdFix;
import net.minecraft.util.datafix.fixes.ItemStackSpawnEggFix;
import net.minecraft.util.datafix.fixes.ItemStackTheFlatteningFix;
import net.minecraft.util.datafix.fixes.ItemStackUUIDFix;
import net.minecraft.util.datafix.fixes.ItemWaterPotionFix;
import net.minecraft.util.datafix.fixes.ItemWrittenBookPagesStrictJsonFix;
import net.minecraft.util.datafix.fixes.JigsawPropertiesFix;
import net.minecraft.util.datafix.fixes.JigsawRotationFix;
import net.minecraft.util.datafix.fixes.LeavesFix;
import net.minecraft.util.datafix.fixes.LevelDataGeneratorOptionsFix;
import net.minecraft.util.datafix.fixes.LevelFlatGeneratorInfoFix;
import net.minecraft.util.datafix.fixes.LevelUUIDFix;
import net.minecraft.util.datafix.fixes.MapIdFix;
import net.minecraft.util.datafix.fixes.MemoryExpiryDataFix;
import net.minecraft.util.datafix.fixes.MissingDimensionFix;
import net.minecraft.util.datafix.fixes.MobSpawnerEntityIdentifiersFix;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.NewVillageFix;
import net.minecraft.util.datafix.fixes.ObjectiveDisplayNameFix;
import net.minecraft.util.datafix.fixes.ObjectiveRenderTypeFix;
import net.minecraft.util.datafix.fixes.OminousBannerBlockEntityRenameFix;
import net.minecraft.util.datafix.fixes.OminousBannerRenameFix;
import net.minecraft.util.datafix.fixes.OptionsAddTextBackgroundFix;
import net.minecraft.util.datafix.fixes.OptionsForceVBOFix;
import net.minecraft.util.datafix.fixes.OptionsKeyLwjgl3Fix;
import net.minecraft.util.datafix.fixes.OptionsKeyTranslationFix;
import net.minecraft.util.datafix.fixes.OptionsLowerCaseLanguageFix;
import net.minecraft.util.datafix.fixes.OptionsRenameFieldFix;
import net.minecraft.util.datafix.fixes.OverreachingTickFix;
import net.minecraft.util.datafix.fixes.PlayerUUIDFix;
import net.minecraft.util.datafix.fixes.RecipesFix;
import net.minecraft.util.datafix.fixes.RecipesRenameFix;
import net.minecraft.util.datafix.fixes.RecipesRenameningFix;
import net.minecraft.util.datafix.fixes.RedstoneWireConnectionsFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.fixes.RemoveGolemGossipFix;
import net.minecraft.util.datafix.fixes.RenameBiomesFix;
import net.minecraft.util.datafix.fixes.RenamedCoralFansFix;
import net.minecraft.util.datafix.fixes.RenamedCoralFix;
import net.minecraft.util.datafix.fixes.ReorganizePoi;
import net.minecraft.util.datafix.fixes.SavedDataFeaturePoolElementFix;
import net.minecraft.util.datafix.fixes.SavedDataUUIDFix;
import net.minecraft.util.datafix.fixes.SavedDataVillageCropFix;
import net.minecraft.util.datafix.fixes.SpawnerDataFix;
import net.minecraft.util.datafix.fixes.StatsCounterFix;
import net.minecraft.util.datafix.fixes.StatsRenameFix;
import net.minecraft.util.datafix.fixes.StriderGravityFix;
import net.minecraft.util.datafix.fixes.StructureReferenceCountFix;
import net.minecraft.util.datafix.fixes.StructureSettingsFlattenFix;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.util.datafix.fixes.TeamDisplayNameFix;
import net.minecraft.util.datafix.fixes.TrappedChestBlockEntityFix;
import net.minecraft.util.datafix.fixes.VillagerDataFix;
import net.minecraft.util.datafix.fixes.VillagerFollowRangeFix;
import net.minecraft.util.datafix.fixes.VillagerRebuildLevelAndXpFix;
import net.minecraft.util.datafix.fixes.VillagerTradeFix;
import net.minecraft.util.datafix.fixes.WallPropertyFix;
import net.minecraft.util.datafix.fixes.WeaponSmithChestLootTableFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsDisallowOldCustomWorldsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.WriteAndReadFix;
import net.minecraft.util.datafix.fixes.ZombieVillagerRebuildXpFix;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import net.minecraft.util.datafix.schemas.V100;
import net.minecraft.util.datafix.schemas.V102;
import net.minecraft.util.datafix.schemas.V1022;
import net.minecraft.util.datafix.schemas.V106;
import net.minecraft.util.datafix.schemas.V107;
import net.minecraft.util.datafix.schemas.V1125;
import net.minecraft.util.datafix.schemas.V135;
import net.minecraft.util.datafix.schemas.V143;
import net.minecraft.util.datafix.schemas.V1451;
import net.minecraft.util.datafix.schemas.V1451_1;
import net.minecraft.util.datafix.schemas.V1451_2;
import net.minecraft.util.datafix.schemas.V1451_3;
import net.minecraft.util.datafix.schemas.V1451_4;
import net.minecraft.util.datafix.schemas.V1451_5;
import net.minecraft.util.datafix.schemas.V1451_6;
import net.minecraft.util.datafix.schemas.V1451_7;
import net.minecraft.util.datafix.schemas.V1460;
import net.minecraft.util.datafix.schemas.V1466;
import net.minecraft.util.datafix.schemas.V1470;
import net.minecraft.util.datafix.schemas.V1481;
import net.minecraft.util.datafix.schemas.V1483;
import net.minecraft.util.datafix.schemas.V1486;
import net.minecraft.util.datafix.schemas.V1510;
import net.minecraft.util.datafix.schemas.V1800;
import net.minecraft.util.datafix.schemas.V1801;
import net.minecraft.util.datafix.schemas.V1904;
import net.minecraft.util.datafix.schemas.V1906;
import net.minecraft.util.datafix.schemas.V1909;
import net.minecraft.util.datafix.schemas.V1920;
import net.minecraft.util.datafix.schemas.V1928;
import net.minecraft.util.datafix.schemas.V1929;
import net.minecraft.util.datafix.schemas.V1931;
import net.minecraft.util.datafix.schemas.V2100;
import net.minecraft.util.datafix.schemas.V2501;
import net.minecraft.util.datafix.schemas.V2502;
import net.minecraft.util.datafix.schemas.V2505;
import net.minecraft.util.datafix.schemas.V2509;
import net.minecraft.util.datafix.schemas.V2519;
import net.minecraft.util.datafix.schemas.V2522;
import net.minecraft.util.datafix.schemas.V2551;
import net.minecraft.util.datafix.schemas.V2568;
import net.minecraft.util.datafix.schemas.V2571;
import net.minecraft.util.datafix.schemas.V2684;
import net.minecraft.util.datafix.schemas.V2686;
import net.minecraft.util.datafix.schemas.V2688;
import net.minecraft.util.datafix.schemas.V2704;
import net.minecraft.util.datafix.schemas.V2707;
import net.minecraft.util.datafix.schemas.V2831;
import net.minecraft.util.datafix.schemas.V2832;
import net.minecraft.util.datafix.schemas.V2842;
import net.minecraft.util.datafix.schemas.V501;
import net.minecraft.util.datafix.schemas.V700;
import net.minecraft.util.datafix.schemas.V701;
import net.minecraft.util.datafix.schemas.V702;
import net.minecraft.util.datafix.schemas.V703;
import net.minecraft.util.datafix.schemas.V704;
import net.minecraft.util.datafix.schemas.V705;
import net.minecraft.util.datafix.schemas.V808;
import net.minecraft.util.datafix.schemas.V99;

public class DataFixers {
    private static final BiFunction<Integer, Schema, Schema> f_14508_ = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> f_14509_ = NamespacedSchema::new;
    private static final DataFixer f_14510_ = DataFixers.m_14529_();

    private static DataFixer m_14529_() {
        DataFixerBuilder datafixerbuilder = new DataFixerBuilder(SharedConstants.m_183709_().getWorldVersion());
        DataFixers.m_14513_(datafixerbuilder);
        return datafixerbuilder.build((Executor)Util.m_183988_());
    }

    public static DataFixer m_14512_() {
        return f_14510_;
    }

    private static void m_14513_(DataFixerBuilder p_14514_) {
        Schema schema = p_14514_.addSchema(99, V99::new);
        Schema schema1 = p_14514_.addSchema(100, V100::new);
        p_14514_.addFixer((DataFix)new EntityEquipmentToArmorAndHandFix(schema1, true));
        Schema schema2 = p_14514_.addSchema(101, f_14508_);
        p_14514_.addFixer((DataFix)new BlockEntitySignTextStrictJsonFix(schema2, false));
        Schema schema3 = p_14514_.addSchema(102, V102::new);
        p_14514_.addFixer((DataFix)new ItemIdFix(schema3, true));
        p_14514_.addFixer((DataFix)new ItemPotionFix(schema3, false));
        Schema schema4 = p_14514_.addSchema(105, f_14508_);
        p_14514_.addFixer((DataFix)new ItemSpawnEggFix(schema4, true));
        Schema schema5 = p_14514_.addSchema(106, V106::new);
        p_14514_.addFixer((DataFix)new MobSpawnerEntityIdentifiersFix(schema5, true));
        Schema schema6 = p_14514_.addSchema(107, V107::new);
        p_14514_.addFixer((DataFix)new EntityMinecartIdentifiersFix(schema6, true));
        Schema schema7 = p_14514_.addSchema(108, f_14508_);
        p_14514_.addFixer((DataFix)new EntityStringUuidFix(schema7, true));
        Schema schema8 = p_14514_.addSchema(109, f_14508_);
        p_14514_.addFixer((DataFix)new EntityHealthFix(schema8, true));
        Schema schema9 = p_14514_.addSchema(110, f_14508_);
        p_14514_.addFixer((DataFix)new EntityHorseSaddleFix(schema9, true));
        Schema schema10 = p_14514_.addSchema(111, f_14508_);
        p_14514_.addFixer((DataFix)new EntityPaintingItemFrameDirectionFix(schema10, true));
        Schema schema11 = p_14514_.addSchema(113, f_14508_);
        p_14514_.addFixer((DataFix)new EntityRedundantChanceTagsFix(schema11, true));
        Schema schema12 = p_14514_.addSchema(135, V135::new);
        p_14514_.addFixer((DataFix)new EntityRidingToPassengersFix(schema12, true));
        Schema schema13 = p_14514_.addSchema(143, V143::new);
        p_14514_.addFixer((DataFix)new EntityTippedArrowFix(schema13, true));
        Schema schema14 = p_14514_.addSchema(147, f_14508_);
        p_14514_.addFixer((DataFix)new EntityArmorStandSilentFix(schema14, true));
        Schema schema15 = p_14514_.addSchema(165, f_14508_);
        p_14514_.addFixer((DataFix)new ItemWrittenBookPagesStrictJsonFix(schema15, true));
        Schema schema16 = p_14514_.addSchema(501, V501::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema16, "Add 1.10 entities fix", References.f_16786_));
        Schema schema17 = p_14514_.addSchema(502, f_14508_);
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema17, (String)"cooked_fished item renamer", p_14533_ -> Objects.equals(NamespacedSchema.m_17311_((String)p_14533_), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : p_14533_));
        p_14514_.addFixer((DataFix)new EntityZombieVillagerTypeFix(schema17, false));
        Schema schema18 = p_14514_.addSchema(505, f_14508_);
        p_14514_.addFixer((DataFix)new OptionsForceVBOFix(schema18, false));
        Schema schema19 = p_14514_.addSchema(700, V700::new);
        p_14514_.addFixer((DataFix)new EntityElderGuardianSplitFix(schema19, true));
        Schema schema20 = p_14514_.addSchema(701, V701::new);
        p_14514_.addFixer((DataFix)new EntitySkeletonSplitFix(schema20, true));
        Schema schema21 = p_14514_.addSchema(702, V702::new);
        p_14514_.addFixer((DataFix)new EntityZombieSplitFix(schema21, true));
        Schema schema22 = p_14514_.addSchema(703, V703::new);
        p_14514_.addFixer((DataFix)new EntityHorseSplitFix(schema22, true));
        Schema schema23 = p_14514_.addSchema(704, V704::new);
        p_14514_.addFixer((DataFix)new BlockEntityIdFix(schema23, true));
        Schema schema24 = p_14514_.addSchema(705, V705::new);
        p_14514_.addFixer((DataFix)new EntityIdFix(schema24, true));
        Schema schema25 = p_14514_.addSchema(804, f_14509_);
        p_14514_.addFixer((DataFix)new ItemBannerColorFix(schema25, true));
        Schema schema26 = p_14514_.addSchema(806, f_14509_);
        p_14514_.addFixer((DataFix)new ItemWaterPotionFix(schema26, false));
        Schema schema27 = p_14514_.addSchema(808, V808::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema27, "added shulker box", References.f_16781_));
        Schema schema28 = p_14514_.addSchema(808, 1, f_14509_);
        p_14514_.addFixer((DataFix)new EntityShulkerColorFix(schema28, false));
        Schema schema29 = p_14514_.addSchema(813, f_14509_);
        p_14514_.addFixer((DataFix)new ItemShulkerBoxColorFix(schema29, false));
        p_14514_.addFixer((DataFix)new BlockEntityShulkerBoxColorFix(schema29, false));
        Schema schema30 = p_14514_.addSchema(816, f_14509_);
        p_14514_.addFixer((DataFix)new OptionsLowerCaseLanguageFix(schema30, false));
        Schema schema31 = p_14514_.addSchema(820, f_14509_);
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema31, (String)"totem item renamer", DataFixers.m_14517_("minecraft:totem", "minecraft:totem_of_undying")));
        Schema schema32 = p_14514_.addSchema(1022, V1022::new);
        p_14514_.addFixer((DataFix)new WriteAndReadFix(schema32, "added shoulder entities to players", References.f_16772_));
        Schema schema33 = p_14514_.addSchema(1125, V1125::new);
        p_14514_.addFixer((DataFix)new ChunkBedBlockEntityInjecterFix(schema33, true));
        p_14514_.addFixer((DataFix)new BedItemColorFix(schema33, false));
        Schema schema34 = p_14514_.addSchema(1344, f_14509_);
        p_14514_.addFixer((DataFix)new OptionsKeyLwjgl3Fix(schema34, false));
        Schema schema35 = p_14514_.addSchema(1446, f_14509_);
        p_14514_.addFixer((DataFix)new OptionsKeyTranslationFix(schema35, false));
        Schema schema36 = p_14514_.addSchema(1450, f_14509_);
        p_14514_.addFixer((DataFix)new BlockStateStructureTemplateFix(schema36, false));
        Schema schema37 = p_14514_.addSchema(1451, V1451::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema37, "AddTrappedChestFix", References.f_16781_));
        Schema schema38 = p_14514_.addSchema(1451, 1, V1451_1::new);
        p_14514_.addFixer((DataFix)new ChunkPalettedStorageFix(schema38, true));
        Schema schema39 = p_14514_.addSchema(1451, 2, V1451_2::new);
        p_14514_.addFixer((DataFix)new BlockEntityBlockStateFix(schema39, true));
        Schema schema40 = p_14514_.addSchema(1451, 3, V1451_3::new);
        p_14514_.addFixer((DataFix)new EntityBlockStateFix(schema40, true));
        p_14514_.addFixer((DataFix)new ItemStackMapIdFix(schema40, false));
        Schema schema41 = p_14514_.addSchema(1451, 4, V1451_4::new);
        p_14514_.addFixer((DataFix)new BlockNameFlatteningFix(schema41, true));
        p_14514_.addFixer((DataFix)new ItemStackTheFlatteningFix(schema41, false));
        Schema schema42 = p_14514_.addSchema(1451, 5, V1451_5::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema42, "RemoveNoteBlockFlowerPotFix", References.f_16781_));
        p_14514_.addFixer((DataFix)new ItemStackSpawnEggFix(schema42, false));
        p_14514_.addFixer((DataFix)new EntityWolfColorFix(schema42, false));
        p_14514_.addFixer((DataFix)new BlockEntityBannerColorFix(schema42, false));
        p_14514_.addFixer((DataFix)new LevelFlatGeneratorInfoFix(schema42, false));
        Schema schema43 = p_14514_.addSchema(1451, 6, V1451_6::new);
        p_14514_.addFixer((DataFix)new StatsCounterFix(schema43, true));
        p_14514_.addFixer((DataFix)new WriteAndReadFix(schema43, "Rewrite objectives", References.f_16791_));
        p_14514_.addFixer((DataFix)new BlockEntityJukeboxFix(schema43, false));
        Schema schema44 = p_14514_.addSchema(1451, 7, V1451_7::new);
        p_14514_.addFixer((DataFix)new SavedDataVillageCropFix(schema44, true));
        Schema schema45 = p_14514_.addSchema(1451, 7, f_14509_);
        p_14514_.addFixer((DataFix)new VillagerTradeFix(schema45, false));
        Schema schema46 = p_14514_.addSchema(1456, f_14509_);
        p_14514_.addFixer((DataFix)new EntityItemFrameDirectionFix(schema46, false));
        Schema schema47 = p_14514_.addSchema(1458, f_14509_);
        p_14514_.addFixer(new DataFix(schema47, false){

            protected TypeRewriteRule makeRule() {
                return this.fixTypeEverywhereTyped("Player CustomName", this.getInputSchema().getType(References.f_16772_), typed -> typed.update(DSL.remainderFinder(), dynamic -> EntityCustomNameToComponentFix.m_15407_((Dynamic)dynamic)));
            }
        });
        p_14514_.addFixer((DataFix)new EntityCustomNameToComponentFix(schema47, false));
        p_14514_.addFixer((DataFix)new ItemCustomNameToComponentFix(schema47, false));
        p_14514_.addFixer((DataFix)new BlockEntityCustomNameToComponentFix(schema47, false));
        Schema schema48 = p_14514_.addSchema(1460, V1460::new);
        p_14514_.addFixer((DataFix)new EntityPaintingMotiveFix(schema48, false));
        Schema schema49 = p_14514_.addSchema(1466, V1466::new);
        p_14514_.addFixer((DataFix)new ChunkToProtochunkFix(schema49, true));
        Schema schema50 = p_14514_.addSchema(1470, V1470::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema50, "Add 1.13 entities fix", References.f_16786_));
        Schema schema51 = p_14514_.addSchema(1474, f_14509_);
        p_14514_.addFixer((DataFix)new ColorlessShulkerEntityFix(schema51, false));
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema51, (String)"Colorless shulker block fixer", p_14531_ -> Objects.equals(NamespacedSchema.m_17311_((String)p_14531_), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : p_14531_));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema51, (String)"Colorless shulker item fixer", p_14516_ -> Objects.equals(NamespacedSchema.m_17311_((String)p_14516_), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : p_14516_));
        Schema schema52 = p_14514_.addSchema(1475, f_14509_);
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema52, (String)"Flowing fixer", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:flowing_water", (Object)"minecraft:water", (Object)"minecraft:flowing_lava", (Object)"minecraft:lava"))));
        Schema schema53 = p_14514_.addSchema(1480, f_14509_);
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema53, (String)"Rename coral blocks", DataFixers.m_14524_(RenamedCoralFix.f_16850_)));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema53, (String)"Rename coral items", DataFixers.m_14524_(RenamedCoralFix.f_16850_)));
        Schema schema54 = p_14514_.addSchema(1481, V1481::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema54, "Add conduit", References.f_16781_));
        Schema schema55 = p_14514_.addSchema(1483, V1483::new);
        p_14514_.addFixer((DataFix)new EntityPufferfishRenameFix(schema55, true));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema55, (String)"Rename pufferfish egg item", DataFixers.m_14524_(EntityPufferfishRenameFix.f_15584_)));
        Schema schema56 = p_14514_.addSchema(1484, f_14509_);
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema56, (String)"Rename seagrass items", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema56, (String)"Rename seagrass blocks", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        p_14514_.addFixer((DataFix)new HeightmapRenamingFix(schema56, false));
        Schema schema57 = p_14514_.addSchema(1486, V1486::new);
        p_14514_.addFixer((DataFix)new EntityCodSalmonFix(schema57, true));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema57, (String)"Rename cod/salmon egg items", DataFixers.m_14524_(EntityCodSalmonFix.f_15390_)));
        Schema schema58 = p_14514_.addSchema(1487, f_14509_);
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema58, (String)"Rename prismarine_brick(s)_* blocks", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema58, (String)"Rename prismarine_brick(s)_* items", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        Schema schema59 = p_14514_.addSchema(1488, f_14509_);
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema59, (String)"Rename kelp/kelptop", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema59, (String)"Rename kelptop", DataFixers.m_14517_("minecraft:kelp_top", "minecraft:kelp")));
        p_14514_.addFixer((DataFix)new NamedEntityFix(schema59, false, "Command block block entity custom name fix", References.f_16781_, "minecraft:command_block"){

            protected Typed<?> m_7504_(Typed<?> p_14549_) {
                return p_14549_.update(DSL.remainderFinder(), EntityCustomNameToComponentFix::m_15407_);
            }
        });
        p_14514_.addFixer((DataFix)new NamedEntityFix(schema59, false, "Command block minecart custom name fix", References.f_16786_, "minecraft:commandblock_minecart"){

            protected Typed<?> m_7504_(Typed<?> p_14549_) {
                return p_14549_.update(DSL.remainderFinder(), EntityCustomNameToComponentFix::m_15407_);
            }
        });
        p_14514_.addFixer((DataFix)new IglooMetadataRemovalFix(schema59, false));
        Schema schema60 = p_14514_.addSchema(1490, f_14509_);
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema60, (String)"Rename melon_block", DataFixers.m_14517_("minecraft:melon_block", "minecraft:melon")));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema60, (String)"Rename melon_block/melon/speckled_melon", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:melon_block", (Object)"minecraft:melon", (Object)"minecraft:melon", (Object)"minecraft:melon_slice", (Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice"))));
        Schema schema61 = p_14514_.addSchema(1492, f_14509_);
        p_14514_.addFixer((DataFix)new ChunkStructuresTemplateRenameFix(schema61, false));
        Schema schema62 = p_14514_.addSchema(1494, f_14509_);
        p_14514_.addFixer((DataFix)new ItemStackEnchantmentNamesFix(schema62, false));
        Schema schema63 = p_14514_.addSchema(1496, f_14509_);
        p_14514_.addFixer((DataFix)new LeavesFix(schema63, false));
        Schema schema64 = p_14514_.addSchema(1500, f_14509_);
        p_14514_.addFixer((DataFix)new BlockEntityKeepPacked(schema64, false));
        Schema schema65 = p_14514_.addSchema(1501, f_14509_);
        p_14514_.addFixer((DataFix)new AdvancementsFix(schema65, false));
        Schema schema66 = p_14514_.addSchema(1502, f_14509_);
        p_14514_.addFixer((DataFix)new RecipesFix(schema66, false));
        Schema schema67 = p_14514_.addSchema(1506, f_14509_);
        p_14514_.addFixer((DataFix)new LevelDataGeneratorOptionsFix(schema67, false));
        Schema schema68 = p_14514_.addSchema(1510, V1510::new);
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema68, (String)"Block renamening fix", DataFixers.m_14524_(EntityTheRenameningFix.f_15702_)));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema68, (String)"Item renamening fix", DataFixers.m_14524_(EntityTheRenameningFix.f_15703_)));
        p_14514_.addFixer((DataFix)new RecipesRenameningFix(schema68, false));
        p_14514_.addFixer((DataFix)new EntityTheRenameningFix(schema68, true));
        p_14514_.addFixer((DataFix)new StatsRenameFix(schema68, "SwimStatsRenameFix", (Map)ImmutableMap.of((Object)"minecraft:swim_one_cm", (Object)"minecraft:walk_on_water_one_cm", (Object)"minecraft:dive_one_cm", (Object)"minecraft:walk_under_water_one_cm")));
        Schema schema69 = p_14514_.addSchema(1514, f_14509_);
        p_14514_.addFixer((DataFix)new ObjectiveDisplayNameFix(schema69, false));
        p_14514_.addFixer((DataFix)new TeamDisplayNameFix(schema69, false));
        p_14514_.addFixer((DataFix)new ObjectiveRenderTypeFix(schema69, false));
        Schema schema70 = p_14514_.addSchema(1515, f_14509_);
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema70, (String)"Rename coral fan blocks", DataFixers.m_14524_(RenamedCoralFansFix.f_16848_)));
        Schema schema71 = p_14514_.addSchema(1624, f_14509_);
        p_14514_.addFixer((DataFix)new TrappedChestBlockEntityFix(schema71, false));
        Schema schema72 = p_14514_.addSchema(1800, V1800::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema72, "Added 1.14 mobs fix", References.f_16786_));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema72, (String)"Rename dye items", DataFixers.m_14524_(DyeItemRenameFix.f_15321_)));
        Schema schema73 = p_14514_.addSchema(1801, V1801::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema73, "Added Illager Beast", References.f_16786_));
        Schema schema74 = p_14514_.addSchema(1802, f_14509_);
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema74, (String)"Rename sign blocks & stone slabs", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign"))));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema74, (String)"Rename sign item & stone slabs", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign"))));
        Schema schema75 = p_14514_.addSchema(1803, f_14509_);
        p_14514_.addFixer((DataFix)new ItemLoreFix(schema75, false));
        Schema schema76 = p_14514_.addSchema(1904, V1904::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema76, "Added Cats", References.f_16786_));
        p_14514_.addFixer((DataFix)new EntityCatSplitFix(schema76, false));
        Schema schema77 = p_14514_.addSchema(1905, f_14509_);
        p_14514_.addFixer((DataFix)new ChunkStatusFix(schema77, false));
        Schema schema78 = p_14514_.addSchema(1906, V1906::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema78, "Add POI Blocks", References.f_16781_));
        Schema schema79 = p_14514_.addSchema(1909, V1909::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema79, "Add jigsaw", References.f_16781_));
        Schema schema80 = p_14514_.addSchema(1911, f_14509_);
        p_14514_.addFixer((DataFix)new ChunkStatusFix2(schema80, false));
        Schema schema81 = p_14514_.addSchema(1914, f_14509_);
        p_14514_.addFixer((DataFix)new WeaponSmithChestLootTableFix(schema81, false));
        Schema schema82 = p_14514_.addSchema(1917, f_14509_);
        p_14514_.addFixer((DataFix)new CatTypeFix(schema82, false));
        Schema schema83 = p_14514_.addSchema(1918, f_14509_);
        p_14514_.addFixer((DataFix)new VillagerDataFix(schema83, "minecraft:villager"));
        p_14514_.addFixer((DataFix)new VillagerDataFix(schema83, "minecraft:zombie_villager"));
        Schema schema84 = p_14514_.addSchema(1920, V1920::new);
        p_14514_.addFixer((DataFix)new NewVillageFix(schema84, false));
        p_14514_.addFixer((DataFix)new AddNewChoices(schema84, "Add campfire", References.f_16781_));
        Schema schema85 = p_14514_.addSchema(1925, f_14509_);
        p_14514_.addFixer((DataFix)new MapIdFix(schema85, false));
        Schema schema86 = p_14514_.addSchema(1928, V1928::new);
        p_14514_.addFixer((DataFix)new EntityRavagerRenameFix(schema86, true));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema86, (String)"Rename ravager egg item", DataFixers.m_14524_(EntityRavagerRenameFix.f_15591_)));
        Schema schema87 = p_14514_.addSchema(1929, V1929::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema87, "Add Wandering Trader and Trader Llama", References.f_16786_));
        Schema schema88 = p_14514_.addSchema(1931, V1931::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema88, "Added Fox", References.f_16786_));
        Schema schema89 = p_14514_.addSchema(1936, f_14509_);
        p_14514_.addFixer((DataFix)new OptionsAddTextBackgroundFix(schema89, false));
        Schema schema90 = p_14514_.addSchema(1946, f_14509_);
        p_14514_.addFixer((DataFix)new ReorganizePoi(schema90, false));
        Schema schema91 = p_14514_.addSchema(1948, f_14509_);
        p_14514_.addFixer((DataFix)new OminousBannerRenameFix(schema91, false));
        Schema schema92 = p_14514_.addSchema(1953, f_14509_);
        p_14514_.addFixer((DataFix)new OminousBannerBlockEntityRenameFix(schema92, false));
        Schema schema93 = p_14514_.addSchema(1955, f_14509_);
        p_14514_.addFixer((DataFix)new VillagerRebuildLevelAndXpFix(schema93, false));
        p_14514_.addFixer((DataFix)new ZombieVillagerRebuildXpFix(schema93, false));
        Schema schema94 = p_14514_.addSchema(1961, f_14509_);
        p_14514_.addFixer((DataFix)new ChunkLightRemoveFix(schema94, false));
        Schema schema95 = p_14514_.addSchema(1963, f_14509_);
        p_14514_.addFixer((DataFix)new RemoveGolemGossipFix(schema95, false));
        Schema schema96 = p_14514_.addSchema(2100, V2100::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema96, "Added Bee and Bee Stinger", References.f_16786_));
        p_14514_.addFixer((DataFix)new AddNewChoices(schema96, "Add beehive", References.f_16781_));
        p_14514_.addFixer((DataFix)new RecipesRenameFix(schema96, false, "Rename sugar recipe", DataFixers.m_14517_("minecraft:sugar", "sugar_from_sugar_cane")));
        p_14514_.addFixer((DataFix)new AdvancementsRenameFix(schema96, false, "Rename sugar recipe advancement", DataFixers.m_14517_("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
        Schema schema97 = p_14514_.addSchema(2202, f_14509_);
        p_14514_.addFixer((DataFix)new ChunkBiomeFix(schema97, false));
        Schema schema98 = p_14514_.addSchema(2209, f_14509_);
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema98, (String)"Rename bee_hive item to beehive", DataFixers.m_14517_("minecraft:bee_hive", "minecraft:beehive")));
        p_14514_.addFixer((DataFix)new BeehivePoiRenameFix(schema98));
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema98, (String)"Rename bee_hive block to beehive", DataFixers.m_14517_("minecraft:bee_hive", "minecraft:beehive")));
        Schema schema99 = p_14514_.addSchema(2211, f_14509_);
        p_14514_.addFixer((DataFix)new StructureReferenceCountFix(schema99, false));
        Schema schema100 = p_14514_.addSchema(2218, f_14509_);
        p_14514_.addFixer((DataFix)new ForcePoiRebuild(schema100, false));
        Schema schema101 = p_14514_.addSchema(2501, V2501::new);
        p_14514_.addFixer((DataFix)new FurnaceRecipeFix(schema101, true));
        Schema schema102 = p_14514_.addSchema(2502, V2502::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema102, "Added Hoglin", References.f_16786_));
        Schema schema103 = p_14514_.addSchema(2503, f_14509_);
        p_14514_.addFixer((DataFix)new WallPropertyFix(schema103, false));
        p_14514_.addFixer((DataFix)new AdvancementsRenameFix(schema103, false, "Composter category change", DataFixers.m_14517_("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
        Schema schema104 = p_14514_.addSchema(2505, V2505::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema104, "Added Piglin", References.f_16786_));
        p_14514_.addFixer((DataFix)new MemoryExpiryDataFix(schema104, "minecraft:villager"));
        Schema schema105 = p_14514_.addSchema(2508, f_14509_);
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema105, (String)"Renamed fungi items to fungus", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema105, (String)"Renamed fungi blocks to fungus", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        Schema schema106 = p_14514_.addSchema(2509, V2509::new);
        p_14514_.addFixer((DataFix)new EntityZombifiedPiglinRenameFix(schema106));
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema106, (String)"Rename zombie pigman egg item", DataFixers.m_14524_(EntityZombifiedPiglinRenameFix.f_15814_)));
        Schema schema107 = p_14514_.addSchema(2511, f_14509_);
        p_14514_.addFixer((DataFix)new EntityProjectileOwnerFix(schema107));
        Schema schema108 = p_14514_.addSchema(2514, f_14509_);
        p_14514_.addFixer((DataFix)new EntityUUIDFix(schema108));
        p_14514_.addFixer((DataFix)new BlockEntityUUIDFix(schema108));
        p_14514_.addFixer((DataFix)new PlayerUUIDFix(schema108));
        p_14514_.addFixer((DataFix)new LevelUUIDFix(schema108));
        p_14514_.addFixer((DataFix)new SavedDataUUIDFix(schema108));
        p_14514_.addFixer((DataFix)new ItemStackUUIDFix(schema108));
        Schema schema109 = p_14514_.addSchema(2516, f_14509_);
        p_14514_.addFixer((DataFix)new GossipUUIDFix(schema109, "minecraft:villager"));
        p_14514_.addFixer((DataFix)new GossipUUIDFix(schema109, "minecraft:zombie_villager"));
        Schema schema110 = p_14514_.addSchema(2518, f_14509_);
        p_14514_.addFixer((DataFix)new JigsawPropertiesFix(schema110, false));
        p_14514_.addFixer((DataFix)new JigsawRotationFix(schema110, false));
        Schema schema111 = p_14514_.addSchema(2519, V2519::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema111, "Added Strider", References.f_16786_));
        Schema schema112 = p_14514_.addSchema(2522, V2522::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema112, "Added Zoglin", References.f_16786_));
        Schema schema113 = p_14514_.addSchema(2523, f_14509_);
        p_14514_.addFixer((DataFix)new AttributesRename(schema113));
        Schema schema114 = p_14514_.addSchema(2527, f_14509_);
        p_14514_.addFixer((DataFix)new BitStorageAlignFix(schema114));
        Schema schema115 = p_14514_.addSchema(2528, f_14509_);
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema115, (String)"Rename soul fire torch and soul fire lantern", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema115, (String)"Rename soul fire torch and soul fire lantern", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_wall_torch", (Object)"minecraft:soul_wall_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        Schema schema116 = p_14514_.addSchema(2529, f_14509_);
        p_14514_.addFixer((DataFix)new StriderGravityFix(schema116, false));
        Schema schema117 = p_14514_.addSchema(2531, f_14509_);
        p_14514_.addFixer((DataFix)new RedstoneWireConnectionsFix(schema117));
        Schema schema118 = p_14514_.addSchema(2533, f_14509_);
        p_14514_.addFixer((DataFix)new VillagerFollowRangeFix(schema118));
        Schema schema119 = p_14514_.addSchema(2535, f_14509_);
        p_14514_.addFixer((DataFix)new EntityShulkerRotationFix(schema119));
        Schema schema120 = p_14514_.addSchema(2550, f_14509_);
        p_14514_.addFixer((DataFix)new WorldGenSettingsFix(schema120));
        Schema schema121 = p_14514_.addSchema(2551, V2551::new);
        p_14514_.addFixer((DataFix)new WriteAndReadFix(schema121, "add types to WorldGenData", References.f_16795_));
        Schema schema122 = p_14514_.addSchema(2552, f_14509_);
        p_14514_.addFixer((DataFix)new RenameBiomesFix(schema122, false, "Nether biome rename", (Map)ImmutableMap.of((Object)"minecraft:nether", (Object)"minecraft:nether_wastes")));
        Schema schema123 = p_14514_.addSchema(2553, f_14509_);
        p_14514_.addFixer((DataFix)new BiomeFix(schema123, false));
        Schema schema124 = p_14514_.addSchema(2558, f_14509_);
        p_14514_.addFixer((DataFix)new MissingDimensionFix(schema124, false));
        p_14514_.addFixer((DataFix)new OptionsRenameFieldFix(schema124, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
        Schema schema125 = p_14514_.addSchema(2568, V2568::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema125, "Added Piglin Brute", References.f_16786_));
        Schema schema126 = p_14514_.addSchema(2571, V2571::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema126, "Added Goat", References.f_16786_));
        Schema schema127 = p_14514_.addSchema(2679, f_14509_);
        p_14514_.addFixer((DataFix)new CauldronRenameFix(schema127, false));
        Schema schema128 = p_14514_.addSchema(2680, f_14509_);
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema128, (String)"Renamed grass path item to dirt path", DataFixers.m_14517_("minecraft:grass_path", "minecraft:dirt_path")));
        p_14514_.addFixer(BlockRenameFixWithJigsaw.m_145163_((Schema)schema128, (String)"Renamed grass path block to dirt path", DataFixers.m_14517_("minecraft:grass_path", "minecraft:dirt_path")));
        Schema schema129 = p_14514_.addSchema(2684, V2684::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema129, "Added Sculk Sensor", References.f_16781_));
        Schema schema130 = p_14514_.addSchema(2686, V2686::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema130, "Added Axolotl", References.f_16786_));
        Schema schema131 = p_14514_.addSchema(2688, V2688::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema131, "Added Glow Squid", References.f_16786_));
        p_14514_.addFixer((DataFix)new AddNewChoices(schema131, "Added Glow Item Frame", References.f_16786_));
        Schema schema132 = p_14514_.addSchema(2690, f_14509_);
        ImmutableMap immutablemap = ImmutableMap.builder().put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:oxidized_copper_block").put((Object)"minecraft:semi_weathered_copper_block", (Object)"minecraft:weathered_copper_block").put((Object)"minecraft:lightly_weathered_copper_block", (Object)"minecraft:exposed_copper_block").put((Object)"minecraft:weathered_cut_copper", (Object)"minecraft:oxidized_cut_copper").put((Object)"minecraft:semi_weathered_cut_copper", (Object)"minecraft:weathered_cut_copper").put((Object)"minecraft:lightly_weathered_cut_copper", (Object)"minecraft:exposed_cut_copper").put((Object)"minecraft:weathered_cut_copper_stairs", (Object)"minecraft:oxidized_cut_copper_stairs").put((Object)"minecraft:semi_weathered_cut_copper_stairs", (Object)"minecraft:weathered_cut_copper_stairs").put((Object)"minecraft:lightly_weathered_cut_copper_stairs", (Object)"minecraft:exposed_cut_copper_stairs").put((Object)"minecraft:weathered_cut_copper_slab", (Object)"minecraft:oxidized_cut_copper_slab").put((Object)"minecraft:semi_weathered_cut_copper_slab", (Object)"minecraft:weathered_cut_copper_slab").put((Object)"minecraft:lightly_weathered_cut_copper_slab", (Object)"minecraft:exposed_cut_copper_slab").put((Object)"minecraft:waxed_semi_weathered_copper", (Object)"minecraft:waxed_weathered_copper").put((Object)"minecraft:waxed_lightly_weathered_copper", (Object)"minecraft:waxed_exposed_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper", (Object)"minecraft:waxed_weathered_cut_copper").put((Object)"minecraft:waxed_lightly_weathered_cut_copper", (Object)"minecraft:waxed_exposed_cut_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper_stairs", (Object)"minecraft:waxed_weathered_cut_copper_stairs").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_stairs", (Object)"minecraft:waxed_exposed_cut_copper_stairs").put((Object)"minecraft:waxed_semi_weathered_cut_copper_slab", (Object)"minecraft:waxed_weathered_cut_copper_slab").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_slab", (Object)"minecraft:waxed_exposed_cut_copper_slab").build();
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema132, (String)"Renamed copper block items to new oxidized terms", DataFixers.m_14524_((Map<String, String>)immutablemap)));
        p_14514_.addFixer(BlockRenameFixWithJigsaw.m_145163_((Schema)schema132, (String)"Renamed copper blocks to new oxidized terms", DataFixers.m_14524_((Map<String, String>)immutablemap)));
        Schema schema133 = p_14514_.addSchema(2691, f_14509_);
        ImmutableMap immutablemap1 = ImmutableMap.builder().put((Object)"minecraft:waxed_copper", (Object)"minecraft:waxed_copper_block").put((Object)"minecraft:oxidized_copper_block", (Object)"minecraft:oxidized_copper").put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:weathered_copper").put((Object)"minecraft:exposed_copper_block", (Object)"minecraft:exposed_copper").build();
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema133, (String)"Rename copper item suffixes", DataFixers.m_14524_((Map<String, String>)immutablemap1)));
        p_14514_.addFixer(BlockRenameFixWithJigsaw.m_145163_((Schema)schema133, (String)"Rename copper blocks suffixes", DataFixers.m_14524_((Map<String, String>)immutablemap1)));
        Schema schema134 = p_14514_.addSchema(2693, f_14509_);
        p_14514_.addFixer((DataFix)new AddFlagIfNotPresentFix(schema134, References.f_16795_, "has_increased_height_already", false));
        Schema schema135 = p_14514_.addSchema(2696, f_14509_);
        ImmutableMap immutablemap2 = ImmutableMap.builder().put((Object)"minecraft:grimstone", (Object)"minecraft:deepslate").put((Object)"minecraft:grimstone_slab", (Object)"minecraft:cobbled_deepslate_slab").put((Object)"minecraft:grimstone_stairs", (Object)"minecraft:cobbled_deepslate_stairs").put((Object)"minecraft:grimstone_wall", (Object)"minecraft:cobbled_deepslate_wall").put((Object)"minecraft:polished_grimstone", (Object)"minecraft:polished_deepslate").put((Object)"minecraft:polished_grimstone_slab", (Object)"minecraft:polished_deepslate_slab").put((Object)"minecraft:polished_grimstone_stairs", (Object)"minecraft:polished_deepslate_stairs").put((Object)"minecraft:polished_grimstone_wall", (Object)"minecraft:polished_deepslate_wall").put((Object)"minecraft:grimstone_tiles", (Object)"minecraft:deepslate_tiles").put((Object)"minecraft:grimstone_tile_slab", (Object)"minecraft:deepslate_tile_slab").put((Object)"minecraft:grimstone_tile_stairs", (Object)"minecraft:deepslate_tile_stairs").put((Object)"minecraft:grimstone_tile_wall", (Object)"minecraft:deepslate_tile_wall").put((Object)"minecraft:grimstone_bricks", (Object)"minecraft:deepslate_bricks").put((Object)"minecraft:grimstone_brick_slab", (Object)"minecraft:deepslate_brick_slab").put((Object)"minecraft:grimstone_brick_stairs", (Object)"minecraft:deepslate_brick_stairs").put((Object)"minecraft:grimstone_brick_wall", (Object)"minecraft:deepslate_brick_wall").put((Object)"minecraft:chiseled_grimstone", (Object)"minecraft:chiseled_deepslate").build();
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema135, (String)"Renamed grimstone block items to deepslate", DataFixers.m_14524_((Map<String, String>)immutablemap2)));
        p_14514_.addFixer(BlockRenameFixWithJigsaw.m_145163_((Schema)schema135, (String)"Renamed grimstone blocks to deepslate", DataFixers.m_14524_((Map<String, String>)immutablemap2)));
        Schema schema136 = p_14514_.addSchema(2700, f_14509_);
        p_14514_.addFixer(BlockRenameFixWithJigsaw.m_145163_((Schema)schema136, (String)"Renamed cave vines blocks", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:cave_vines_head", (Object)"minecraft:cave_vines", (Object)"minecraft:cave_vines_body", (Object)"minecraft:cave_vines_plant"))));
        Schema schema137 = p_14514_.addSchema(2701, f_14509_);
        p_14514_.addFixer((DataFix)new SavedDataFeaturePoolElementFix(schema137));
        Schema schema138 = p_14514_.addSchema(2702, f_14509_);
        p_14514_.addFixer((DataFix)new AbstractArrowPickupFix(schema138));
        Schema schema139 = p_14514_.addSchema(2704, V2704::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema139, "Added Goat", References.f_16786_));
        Schema schema140 = p_14514_.addSchema(2707, V2707::new);
        p_14514_.addFixer((DataFix)new AddNewChoices(schema140, "Added Marker", References.f_16786_));
        p_14514_.addFixer((DataFix)new AddFlagIfNotPresentFix(schema140, References.f_16795_, "has_increased_height_already", true));
        Schema schema141 = p_14514_.addSchema(2710, f_14509_);
        p_14514_.addFixer((DataFix)new StatsRenameFix(schema141, "Renamed play_one_minute stat to play_time", (Map)ImmutableMap.of((Object)"minecraft:play_one_minute", (Object)"minecraft:play_time")));
        Schema schema142 = p_14514_.addSchema(2717, f_14509_);
        p_14514_.addFixer(ItemRenameFix.m_16003_((Schema)schema142, (String)"Rename azalea_leaves_flowers", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        p_14514_.addFixer(BlockRenameFix.m_14914_((Schema)schema142, (String)"Rename azalea_leaves_flowers items", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        Schema schema143 = p_14514_.addSchema(2825, f_14509_);
        p_14514_.addFixer((DataFix)new AddFlagIfNotPresentFix(schema143, References.f_16795_, "has_increased_height_already", false));
        Schema schema144 = p_14514_.addSchema(2831, V2831::new);
        p_14514_.addFixer((DataFix)new SpawnerDataFix(schema144));
        Schema schema145 = p_14514_.addSchema(2832, V2832::new);
        p_14514_.addFixer((DataFix)new WorldGenSettingsHeightAndBiomeFix(schema145));
        p_14514_.addFixer((DataFix)new ChunkHeightAndBiomeFix(schema145));
        Schema schema146 = p_14514_.addSchema(2833, f_14509_);
        p_14514_.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix(schema146));
        Schema schema147 = p_14514_.addSchema(2838, f_14509_);
        p_14514_.addFixer((DataFix)new RenameBiomesFix(schema147, false, "Caves and Cliffs biome renames", (Map)CavesAndCliffsRenames.f_184821_));
        Schema schema148 = p_14514_.addSchema(2841, f_14509_);
        p_14514_.addFixer((DataFix)new ChunkProtoTickListFix(schema148));
        Schema schema149 = p_14514_.addSchema(2842, V2842::new);
        p_14514_.addFixer((DataFix)new ChunkRenamesFix(schema149));
        Schema schema150 = p_14514_.addSchema(2843, f_14509_);
        p_14514_.addFixer((DataFix)new OverreachingTickFix(schema150));
        p_14514_.addFixer((DataFix)new RenameBiomesFix(schema150, false, "Remove Deep Warm Ocean", Map.of("minecraft:deep_warm_ocean", "minecraft:warm_ocean")));
        Schema schema151 = p_14514_.addSchema(2846, f_14509_);
        p_14514_.addFixer((DataFix)new AdvancementsRenameFix(schema151, false, "Rename some C&C part 2 advancements", DataFixers.m_14524_((Map<String, String>)ImmutableMap.of((Object)"minecraft:husbandry/play_jukebox_in_meadows", (Object)"minecraft:adventure/play_jukebox_in_meadows", (Object)"minecraft:adventure/caves_and_cliff", (Object)"minecraft:adventure/fall_from_world_height", (Object)"minecraft:adventure/ride_strider_in_overworld_lava", (Object)"minecraft:nether/ride_strider_in_overworld_lava"))));
        Schema schema152 = p_14514_.addSchema(2852, f_14509_);
        p_14514_.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix(schema152));
        Schema schema153 = p_14514_.addSchema(2967, f_14509_);
        p_14514_.addFixer((DataFix)new StructureSettingsFlattenFix(schema153));
        Schema schema154 = p_14514_.addSchema(2970, f_14509_);
        p_14514_.addFixer((DataFix)new StructuresBecomeConfiguredFix(schema154));
    }

    private static UnaryOperator<String> m_14524_(Map<String, String> p_14525_) {
        return p_14528_ -> p_14525_.getOrDefault(p_14528_, (String)p_14528_);
    }

    private static UnaryOperator<String> m_14517_(String p_14518_, String p_14519_) {
        return p_14523_ -> Objects.equals(p_14523_, p_14518_) ? p_14519_ : p_14523_;
    }
}

